<?php
/* --------------------------------------------------------------
   DeletionOfMultipleWithdrawalsRequested.php 2020-03-25
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\Withdrawal\Events;

use Gambio\Admin\Withdrawal\Interfaces\WithdrawalIds;

/**
 * Class DeletionOfMultipleWithdrawalsRequested
 *
 * @package Gambio\Admin\Withdrawal\Events
 */
class DeletionOfMultipleWithdrawalsRequested
{
    /**
     * @var WithdrawalIds
     */
    private $withdrawalIds;
    
    
    /**
     * DeletionOfMultipleWithdrawalsRequested constructor.
     *
     * @param WithdrawalIds $withdrawalIds
     */
    private function __construct(WithdrawalIds $withdrawalIds)
    {
        $this->withdrawalIds = $withdrawalIds;
    }
    
    
    /**
     * @param WithdrawalIds $withdrawalIds
     *
     * @return DeletionOfMultipleWithdrawalsRequested
     */
    public static function create(WithdrawalIds $withdrawalIds): DeletionOfMultipleWithdrawalsRequested
    {
        return new self($withdrawalIds);
    }
    
    
    /**
     * @return WithdrawalIds
     */
    public function withdrawalIds(): WithdrawalIds
    {
        return $this->withdrawalIds;
    }
    
    
    /**
     * @param WithdrawalIds $withdrawalIds
     */
    public function replaceWithdrawals(WithdrawalIds $withdrawalIds): void
    {
        $this->withdrawalIds = $withdrawalIds;
    }
}